package ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.ConverterContext;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.DataFieldToJsonConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.JsonToDataFieldConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.NodeConversionSettings;
import ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap.DataFieldNode;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;

/**
 * @author Denis Bakharev
 */
public class FlatObjectTypeConverter extends TypeConverter {
    @Override
    public String getConvertedTypeName() {
        return "flat-object";
    }

    @Override
    public void writeDataField(JsonToDataFieldConverter converter, ConverterContext<JacksonJsonNodeWrapper> context) {
        writeLeafs(converter, context, Cf.arrayList(context.settings.nodeName));
    }

    @Override
    public void writeJson(DataFieldToJsonConverter converter, ConverterContext<DataFieldNode> context) {

        raiseTreeFromLeafs(
                converter,
                context.settings,
                context.parent.get().dataNode,
                Cf.arrayList(context.settings.nodeName));
    }

    private void writeLeafs(
            JsonToDataFieldConverter converter,
            ConverterContext<JacksonJsonNodeWrapper> context,
            ListF<String> pathToLeaf)
    {
        JacksonJsonNodeWrapper dataNode = context.dataNode;
        if (dataNode.isObject()) {
            for (String name : dataNode.getFieldNames()) {
                writeLeafs(converter, context.withChildNode(name), pathToLeaf.plus(name));
            }
        } else {
            converter.writer.writeFieldName(getLeafName(pathToLeaf));

            converter.convert(context);
        }
    }

    private void raiseTreeFromLeafs(
            DataFieldToJsonConverter converter,
            NodeConversionSettings nodeSettings,
            DataFieldNode flatObjectRoot,
            ListF<String> pathParts)
    {
        converter.writer.writeFieldName(nodeSettings.nodeName);
        converter.writer.writeObjectStart();

        for (NodeConversionSettings childNodeSettings : nodeSettings.children.values()) {
            ListF<String> childPathParts = pathParts.plus(childNodeSettings.nodeName);

            if (childNodeSettings.getActualType().equals("object")) {
                raiseTreeFromLeafs(converter, childNodeSettings, flatObjectRoot, childPathParts);
            } else {
                Option<DataField> leafO = flatObjectRoot.dataField.mapValue().getO(getLeafName(childPathParts));
                if(leafO.isPresent()) {
                    converter.writer.writeFieldName(childNodeSettings.nodeName);
                    converter.convert(new ConverterContext<>(
                            Option.empty(), childNodeSettings, new DataFieldNode(leafO.get())));
                }
            }
        }

        converter.writer.writeObjectEnd();
    }

    private String getLeafName(ListF<String> pathToLeaf) {
        return String.join("_", pathToLeaf);
    }

    @Override
    public boolean isIgnoreNullDataNodes() {
        return false;
    }
}
