package ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters;

import ru.yandex.chemodan.app.dataapi.utils.dataconversion.AbstractConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.ConverterContext;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.NodeConversionSettings;
import ru.yandex.misc.bender.parse.BenderJsonNode;

/**
 * @author Denis Bakharev
 */
public class ObjectTypeConverter extends UniformConverter {

    @Override
    public String getConvertedTypeName() {
        return "object";
    }

    @Override
    protected <TNode extends BenderJsonNode> void write(
            AbstractConverter<?, TNode> converter, ConverterContext<TNode> context)
    {
        converter.writer.writeObjectStart();

        for (NodeConversionSettings childNodeSettings: context.settings.children.values()) {
            String childNodeName = childNodeSettings.nodeName;

            ConverterContext<TNode> childContext = context.withChildNode(childNodeName);
            if(childContext.dataNode != null && !childContext.dataNode.isNull()) {
                converter.writer.writeFieldName(childNodeName);
            }

            converter.convert(childContext);
        }

        converter.writer.writeObjectEnd();
    }
}
