package ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters;

import ru.yandex.chemodan.app.dataapi.utils.dataconversion.AbstractConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.ConverterContext;
import ru.yandex.misc.bender.parse.BenderJsonNode;

/**
 * @author Denis Bakharev
 */
public class StringTypeConverter extends UniformConverter {
    @Override
    public String getConvertedTypeName() {
        return "string";
    }

    @Override
    protected <TNode extends BenderJsonNode> void write(
            AbstractConverter<?, TNode> converter, ConverterContext<TNode> context)
    {
        converter.writer.writeString(context.dataNode.getValueAsString());
    }
}
