package ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters;

import org.joda.time.Instant;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.ConverterContext;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.DataFieldToJsonConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.JsonToDataFieldConverter;
import ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap.DataFieldNode;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;

/**
 * @author Denis Bakharev
 */
public class TimestampTypeConverter extends TypeConverter {
    @Override
    public String getConvertedTypeName() {
        return "timestamp";
    }

    @Override
    public void writeDataField(
            JsonToDataFieldConverter converter, ConverterContext<JacksonJsonNodeWrapper> context)
    {
        converter.writer.write(DataField.timestamp(Instant.parse(context.dataNode.getValueAsString())));
    }

    @Override
    public void writeJson(
            DataFieldToJsonConverter converter, ConverterContext<DataFieldNode> context)
    {
        Instant timeStamp;
        if (context.dataNode.dataField.value instanceof String) {
            /**
             * here we validate String is timestamp, if yes we return it! (possible reason - changed schema)
             * the ide is better to return data if it is valid
             */
            timeStamp = Instant.parse(context.dataNode.getValueAsString());
        } else {
            timeStamp = context.dataNode.dataField.timestampValue();
        }
        converter.writer.writeString(timeStamp.toString());
    }
}
