package ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters;

import org.joda.time.Instant;
import org.junit.Test;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.DataConversionUnitTestBase;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class TimestampTypeConverterTest extends DataConversionUnitTestBase {
    @Test
    public void doConversionTest() {

        String jsonSchema =
                "{\n"
                + "  \"type\": \"object\",\n"
                + "  \"properties\": {\n"
                + "    \"prop1\": {\"type\": \"string\", \"dataapi-convert-type\":\"timestamp\"}\n"
                + "  }\n"
                + "}";

        String jsonInput =
                "{ \"prop1\":\"2015-05-28T17:57:52.000Z\" }";

        MapF<String, DataField> map = doConvertCycle(jsonSchema, jsonInput);

        Assert.equals(1, map.size());
        Assert.equals(DataField.timestamp(Instant.parse("2015-05-28T17:57:52.000Z")), map.getTs("prop1"));
    }
}
