package ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters;

import ru.yandex.chemodan.app.dataapi.utils.dataconversion.ConverterContext;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.DataFieldToJsonConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.JsonToDataFieldConverter;
import ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap.DataFieldNode;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;

/**
 * @author Denis Bakharev
 */
public abstract class TypeConverter {
    public abstract String getConvertedTypeName();

    public abstract void writeDataField(JsonToDataFieldConverter converter, ConverterContext<JacksonJsonNodeWrapper> context);

    public abstract void writeJson(DataFieldToJsonConverter converter, ConverterContext<DataFieldNode> context);

    public boolean isIgnoreNullDataNodes() {
        return true;
    }
}
