package ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters;

import ru.yandex.chemodan.app.dataapi.utils.dataconversion.AbstractConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.ConverterContext;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.DataFieldToJsonConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.JsonToDataFieldConverter;
import ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap.DataFieldNode;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;

/**
 * @author Denis Bakharev
 */
public abstract class UniformConverter extends TypeConverter {
    @Override
    public void writeDataField(JsonToDataFieldConverter converter, ConverterContext<JacksonJsonNodeWrapper> context) {
        write(converter, context);
    }

    @Override
    public void writeJson(DataFieldToJsonConverter converter, ConverterContext<DataFieldNode> context) {
        write(converter, context);
    }

    protected abstract <TNode extends BenderJsonNode> void write(
            AbstractConverter<?, TNode> converter, ConverterContext<TNode> context);

}
