package ru.yandex.chemodan.app.dataapi.utils.elliptics;

import org.apache.http.client.HttpClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.inside.elliptics.EllipticsProxyClient;
import ru.yandex.misc.monica.core.blocks.InstrumentMap;

/**
 * @author Denis Bakharev
 */
@Configuration
public class EllipticsContextConfiguration {

    @Bean
    public EllipticsProxyClient dataapiEllipticsClient(
            @Value("${elliptics.url}")
            String ellipticsUrl,
            @Value("${elliptics.port.read}")
            int ellipticsReadPort,
            @Value("${elliptics.port.write}")
            int ellipticsWritePort,
            @Value("${dataapi.elliptics.authorization.header}")
            String authHeader)
    {
        HttpClient httpClient = ellipticsHttpClientConfigurator().configure();

        EllipticsProxyClient ellipticsProxyClient = new EllipticsProxyClient(
                ellipticsUrl,
                httpClient,
                ellipticsReadPort,
                ellipticsWritePort,
                new InstrumentMap(),
                true);

        ellipticsProxyClient.setAuthorizationHeader(authHeader);
        return ellipticsProxyClient;
    }

    @Bean
    @OverridableValuePrefix("elliptics")
    public HttpClientConfigurator ellipticsHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean EllipticsHelper ellipticsHelper(
            EllipticsProxyClient ellipticsProxyClient,
            @Value("${dataapi.elliptics.namespace}")
            String ellipticsNamespace)
    {
        return new EllipticsHelper(ellipticsProxyClient, ellipticsNamespace);
    }
}
