package ru.yandex.chemodan.app.dataapi.utils.elliptics;

import ru.yandex.inside.elliptics.EllipticsFileNotFoundException;
import ru.yandex.inside.elliptics.EllipticsFilename;
import ru.yandex.inside.elliptics.EllipticsProxyClient;
import ru.yandex.inside.elliptics.EllipticsUploadState;

/**
 * @author Denis Bakharev
 */
public class EllipticsHelper {
    private final EllipticsProxyClient ellipticsProxyClient;
    private final String ellipticsNamespace;

    public EllipticsHelper(EllipticsProxyClient ellipticsProxyClient, String ellipticsNamespace) {
        this.ellipticsProxyClient = ellipticsProxyClient;
        this.ellipticsNamespace = ellipticsNamespace;
    }

    public EllipticsUploadState upload(String filename, byte[] data) {
        return ellipticsProxyClient.upload(new EllipticsFilename(ellipticsNamespace, filename), data);
    }

    public byte[] download(String key) {
        EllipticsFilename ellipticsFilename = new EllipticsFilename(ellipticsNamespace, getNameFromKey(key), key);
        return ellipticsProxyClient.download(ellipticsFilename);
    }

    public void delete(String key) {
        try {
            ellipticsProxyClient.delete(new EllipticsFilename(ellipticsNamespace, getNameFromKey(key), key));
        } catch (EllipticsFileNotFoundException ignored) {
        }
    }

    private static String getNameFromKey(String key) {
        String[] parts = key.split("/");
        return parts[1];
    }
}
