package ru.yandex.chemodan.app.dataapi.utils.elliptics;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.chemodan.app.dataapi.core.dao.test.ActivateDataApiEmbeddedPg;
import ru.yandex.chemodan.app.dataapi.test.DataApiTestSupport;
import ru.yandex.inside.elliptics.EllipticsUploadState;
import ru.yandex.misc.random.Random2;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
@ActivateDataApiEmbeddedPg
public class EllipticsHelperTest extends DataApiTestSupport {
    @Autowired
    EllipticsHelper ellipticsHelper;

    @Test
    public void downloadTest() {
        EllipticsUploadState state = ellipticsHelper.upload(Random2.R.nextString(10), new byte[] {1, 2, 3, 4});
        try {
            byte[] bytes = ellipticsHelper.download(state.getKey());
            Assert.isTrue(bytes.length == 4);
            Assert.equals((byte) 1, bytes[0]);
            Assert.equals((byte) 2, bytes[1]);
            Assert.equals((byte) 3, bytes[2]);
            Assert.equals((byte) 4, bytes[3]);
        }
        finally {
            ellipticsHelper.delete(state.getKey());
        }

    }
}
