package ru.yandex.chemodan.app.dataapi.utils.memcached;

import java.util.concurrent.TimeUnit;

import net.spy.memcached.MemcachedClient;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.spring.Service;

/**
 * @author Denis Bakharev
 */
public class MemcachedClients implements Service {
    public final Option<MemcachedClient> mainMemcachedClient;
    public final ListF<MemcachedClient> additionalClients;
    public final ListF<MemcachedClient> allClients;

    public MemcachedClients(Option<MemcachedClient> mainMemcachedClient, ListF<MemcachedClient> additionalClients) {
        this.mainMemcachedClient = mainMemcachedClient;
        this.additionalClients = additionalClients;
        this.allClients = mainMemcachedClient.plus(additionalClients);
    }

    @Override
    public void start() throws Exception {
        //do nothing
    }

    @Override
    public void stop() throws Exception {
        allClients.parallelStream().forEach(client -> client.shutdown(5, TimeUnit.SECONDS));
    }
}
