package ru.yandex.chemodan.app.dataapi.utils.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;

import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.MemcachedClient;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.admin.conductor.Conductor;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Denis Bakharev
 */
public class MemcachedConfigurationUtils {

    private static final Logger logger = LoggerFactory.getLogger(MemcachedConfigurationUtils.class);

    private static MemcachedClient consMemcachedClient(Conductor conductor, String mainMemcachedHostPorts) {
        try {
            return new MemcachedClient(
                    new BinaryConnectionFactory(),
                    parseMemcachedHosts(mainMemcachedHostPorts, conductor)
            );
        } catch (IOException e) {
            throw ExceptionUtils.translate(e);
        }
    }

    private static List<InetSocketAddress> parseMemcachedHosts(String hostPortsStr, Conductor conductor) {
        return Cf
                .x(hostPortsStr.split(","))
                .flatMap(
                        hostPortStr -> {
                            String[] parts = hostPortStr.split(":");
                            int port = Integer.parseInt(parts[1]);
                            ListF<String> hosts = conductor.resolveHostsFromString(parts[0]);
                            return hosts.map(host -> new InetSocketAddress(host, port));
                        });
    }

    public static Option<MemcachedClient> createMemcachedClient(Conductor conductor, String oneHostAndPortString) {
        Option<MemcachedClient> mainMemcachedClient = Option.empty();
        if (!oneHostAndPortString.isEmpty()) {
            try {
                mainMemcachedClient = Option.of(consMemcachedClient(conductor, oneHostAndPortString));
            } catch (Exception e) {
                logger.error("Can't add memcache {}", oneHostAndPortString, e);
            }
        }
        return mainMemcachedClient;
    }
}
