package ru.yandex.chemodan.app.dataapi.utils.memcached;

import java.util.Optional;

import net.spy.memcached.MemcachedClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.inside.admin.conductor.Conductor;

/**
 * @author Denis Bakharev
 */
@Profile("dataapi")
@Configuration
public class MemcachedContextConfiguration {
    @Bean
    public MemcachedClients memcachedClients(
            Conductor conductor,
            @Value("${dataapi.memcached.host-ports.main:-}")
            Optional<String> mainMemcachedHostPorts,
            @Value("${dataapi.memcached.host-ports.additional:-}")
            Optional<String> additionalMemcachedHostPorts)
    {
        Option<MemcachedClient> mainClient = Option.x(mainMemcachedHostPorts).flatMapO(s -> MemcachedConfigurationUtils.createMemcachedClient(conductor, s));
        ListF<MemcachedClient> additionalClient = additionalMemcachedHostPorts.isPresent() ? Cf.x(additionalMemcachedHostPorts.get().split(";"))
                .map(hostPorts -> MemcachedConfigurationUtils.createMemcachedClient(conductor, hostPorts))
                .flatten() : Cf.list();
        return new MemcachedClients(mainClient, additionalClient);
    }
}
