package ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap;

import org.joda.time.DateTime;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.misc.bender.Bender;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.bender.config.BenderConfiguration;
import ru.yandex.misc.bender.config.CustomMarshallerUnmarshallerFactoryBuilder;

/**
 * @author tolmalev
 */
public class DataFieldMapSerializer<T> {
    private final BenderParserSerializer<T> parserSerializer;

    public DataFieldMapSerializer(Class<T> clazz) {
        parserSerializer = Bender.cons(clazz, configuration);
    }

    private static final BenderConfiguration configuration = new BenderConfiguration(
            BenderConfiguration.defaultSettings(),
            CustomMarshallerUnmarshallerFactoryBuilder
                    .cons()
                    .add(Instant.class, new GenericDataFieldMarshaller<>(DataFieldWriter::writeInstant))
                    .add(Instant.class, new GenericDataFieldUnmarshaller<>(DataFieldNode::getInstant))
                    .add(DateTime.class, new GenericDataFieldMarshaller<>(DataFieldWriter::writeDateTime))
                    .add(DateTime.class, new GenericDataFieldUnmarshaller<>(DataFieldNode::getDateTime))
                    .build()
    );

    public T deserialize(MapF<String, DataField> dataField) {
        DataFieldNode rootNode = new DataFieldNode(DataField.map(dataField));
        return parserSerializer.getParser().parseJson(rootNode);
    }

    public MapF<String, DataField> serialize(T object) {
        DataFieldWriter writer = new DataFieldWriter();
        parserSerializer.getSerializer().serializeJson(object, writer);
        return writer.getResult();
    }
}
