package ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap;

import org.junit.Test;

/**
 * @author tolmalev
 */
public class DataFieldWriterTest {

    @Test
    public void nestedObject() {
//        {
//            "a": {
//                "b": {
//                    "array": [1, 2, 3]
//                }
//            }
//        }

        DataFieldWriter writer = new DataFieldWriter();
        writer.writeObjectStart();

        writer.writeFieldName("a");
        writer.writeObjectStart();
        writer.writeFieldName("b");
        writer.writeObjectStart();

        writer.writeFieldName("arr");
        writer.writeArrayStart();
        writer.writeNumber(1);
        writer.writeNumber(2);
        writer.writeNumber(3);
        writer.writeArrayEnd();

        writer.writeObjectEnd();
        writer.writeObjectEnd();

        writer.writeObjectEnd();
        writer.getResult();
    }

    @Test
    public void simpleArray() {
        // { "array": [ [1, 2, 3]}
        DataFieldWriter writer = new DataFieldWriter();
        writer.writeObjectStart();
        writer.writeFieldName("array");

        writer.writeArrayStart();
        writer.writeNumber(1);
        writer.writeNumber(2);
        writer.writeNumber(3);
        writer.writeArrayEnd();

        writer.writeObjectEnd();
        writer.getResult();
    }

    @Test
    public void simpleObjectWithArray() {
//        {
//            "a": 1,
//            "b": [1, 2, 3],
//            "c": "str"
//        }

        DataFieldWriter writer = new DataFieldWriter();
        writer.writeObjectStart();

        writer.writeFieldName("a");
        writer.writeNumber(1);

        writer.writeFieldName("b");
        writer.writeArrayStart();
        writer.writeNumber(1);
        writer.writeNumber(2);
        writer.writeNumber(3);
        writer.writeArrayEnd();

        writer.writeFieldName("c");
        writer.writeString("str");

        writer.writeObjectEnd();
        writer.getResult();
    }

    @Test
    public void nestedArrays() {
        // { "array": [ [1, 2], [3, 4], [5, 6]]}
        DataFieldWriter writer = new DataFieldWriter();

        writer.writeObjectStart();
        writer.writeFieldName("array");

        writer.writeArrayStart();

        writer.writeArrayStart();
        writer.writeNumber(1);
        writer.writeNumber(2);
        writer.writeArrayEnd();

        writer.writeArrayStart();
        writer.writeNumber(3);
        writer.writeNumber(4);
        writer.writeArrayEnd();

        writer.writeArrayStart();
        writer.writeNumber(5);
        writer.writeNumber(6);
        writer.writeArrayEnd();

        writer.writeArrayEnd();

        writer.writeObjectEnd();
        writer.getResult();
    }
}
