package ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap;


import ru.yandex.bolts.function.Function2V;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.bender.serialize.simpleType.SimpleTypeMarshallerSupport;

/**
 * @author Denis Bakharev
 */
public class GenericDataFieldMarshaller<TType> extends SimpleTypeMarshallerSupport {

    private final Function2V<DataFieldWriter, TType> writerFunc;

    public GenericDataFieldMarshaller(Function2V<DataFieldWriter, TType> writerFunc) {
        this.writerFunc = writerFunc;
    }

    @Override
    protected String toStringValueForXml(Object o) {
        throw new IllegalStateException("XML is not supported");
    }

    @Override
    protected void writeJson(BenderJsonWriter json, Object o) {
        DataFieldWriter writer = (DataFieldWriter) json;
        writerFunc.apply(writer, (TType)o);
    }

}
