package ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap;

import org.w3c.dom.Node;

import ru.yandex.bolts.function.Function;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.FieldLevelUnmarshaller;
import ru.yandex.misc.bender.parse.ParseResult;
import ru.yandex.misc.bender.parse.UnmarshallerContext;

/**
 * @author Denis Bakharev
 */
public class GenericDataFieldUnmarshaller<TType> implements FieldLevelUnmarshaller {

    private final Function<DataFieldNode, TType> getObjectFunc;

    public GenericDataFieldUnmarshaller(Function<DataFieldNode, TType> getObjectFunc) {
        this.getObjectFunc = getObjectFunc;
    }

    @Override
    public ParseResult<Object> parseXmlNode(Node node, UnmarshallerContext unmarshallerContext) {
        throw new RuntimeException("Only JSON is supported");
    }

    @Override
    public ParseResult<Object> parseJsonNode(BenderJsonNode dataFieldNode, UnmarshallerContext unmarshallerContext) {
        TType funcResult = getObjectFunc.apply((DataFieldNode) dataFieldNode);
        return ParseResult.<Object>result(funcResult);
    }
}


