package ru.yandex.chemodan.app.dataapi.utils.xiva;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserType;
import ru.yandex.chemodan.xiva.XivaClient;
import ru.yandex.chemodan.xiva.XivaSingleTokenClient;

/**
 * @author akirakozov
 */
public class XivaClientMultiplexed {
    private final XivaClient publicClient;
    private final XivaClient yaTeamClient;

    public XivaClientMultiplexed(XivaClient publicClient, XivaClient yaTeamClient) {
        this.publicClient = publicClient;
        this.yaTeamClient = yaTeamClient;
    }

    public SingleToken toSingleTokenClient(String unicastService, String broadcastService) {
        return new SingleToken(
                publicClient.toSingleTokenClient(unicastService, broadcastService),
                yaTeamClient.toSingleTokenClient(unicastService)
        );
    }

    public static class SingleToken {
        private final XivaSingleTokenClient publicClient;
        private final XivaSingleTokenClient yaTeamClient;

        SingleToken(XivaSingleTokenClient publicClient, XivaSingleTokenClient yaTeamClient) {
            this.publicClient = publicClient;
            this.yaTeamClient = yaTeamClient;
        }

        public XivaSingleTokenClient byUserId(DataApiUserId userId) {
            return userId.type == DataApiUserType.YT ? yaTeamClient : publicClient;
        }
    }
}
