package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.chemodan.app.dataapi.utils.HttpStatusCodeSourceWithErrorLevel;
import ru.yandex.chemodan.util.exception.A3ExceptionWithNoStackTrace;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class AccessForbiddenException extends A3ExceptionWithNoStackTrace implements HttpStatusCodeSourceWithErrorLevel {

    public AccessForbiddenException(String message) {
        super(ru.yandex.chemodan.util.web.ErrorNames.FORBIDDEN, message);
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_403_FORBIDDEN;
    }

}
