package ru.yandex.chemodan.app.dataapi.web;

import java.util.List;
import java.util.Optional;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.AppInfoInvocationInterceptor;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.web.admin.DataApiActionsAdminContextConfiguration;
import ru.yandex.chemodan.app.dataapi.web.auth.SetUserAndAppInfoInterceptorBase;
import ru.yandex.chemodan.app.dataapi.web.auth.SetUserAndAppInterceptorsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiAppBinder;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiUserIdBinder;
import ru.yandex.chemodan.app.dataapi.web.direct.a3.CompoundJsonPojoResultSerializer;
import ru.yandex.chemodan.app.dataapi.web.direct.a3.CompoundProtobufResultSerializer;
import ru.yandex.chemodan.app.dataapi.web.direct.a3.DirectDataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.web.profile.ProfileBatchGetAction;
import ru.yandex.chemodan.app.dataapi.web.ratelimiter.DataapiRateLimiterInterceptor;
import ru.yandex.chemodan.app.dataapi.web.ratelimiter.RateLimiterConfiguration;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyBatchInterceptor;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.app.dataapi.web.xiva.XivaSubscriptionActionContextConfiguration;
import ru.yandex.chemodan.boot.ChemodanActionAppConfigurator;
import ru.yandex.chemodan.cloud.auth.PlatformSecurityConfiguration;
import ru.yandex.chemodan.cloud.auth.SecurityPlatformDispatcher;
import ru.yandex.chemodan.cloud.auth.config.ZkPlatformConfiguration;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.chemodan.util.web.interceptors.ThreadLocalCacheInterceptor;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.Feature;
import ru.yandex.commune.a3.action.intercept.ActionDispatcherInterceptor;
import ru.yandex.commune.a3.action.result.ApplicationInfo;
import ru.yandex.commune.a3.action.result.error.ExceptionResolver;
import ru.yandex.misc.bender.BenderMapper;

/**
 * @author Denis Bakharev
 */
@Configuration
@Import({
        DataApiActionsAdminContextConfiguration.class,
        DataApiActionsContextConfiguration.class,
        PlatformSecurityConfiguration.class,
        ZkPlatformConfiguration.class,
        SetUserAndAppInterceptorsContextConfiguration.class,
        XivaSubscriptionActionContextConfiguration.class,
        RateLimiterConfiguration.class
})
public class ActionsContextConfiguration {

    @Autowired(required=false)
    private ProfileBatchGetAction profileBatchGetAction;

    @Bean
    public ActionApp actionApp(
            List<SetUserAndAppInfoInterceptorBase> setUserAndAppInfoInterceptors,
            ApplicationContext context,
            ApplicationInfo applicationInfo,
            Optional<ProxyInterceptor> proxyInterceptor,
            Optional<ProxyBatchInterceptor> proxyBatchInterceptor,
            Optional<SecurityPlatformDispatcher> securityPlatformInterceptor,
            Optional<DataapiRateLimiterInterceptor> rateLimiterInterceptor)
    {

        BenderMapper generalBenderMapper = DataApiBenderUtils.mapper();
        BenderMapper directBenderMapper = DirectDataApiBenderUtils.mapper();

        ChemodanActionAppConfigurator configurator = ChemodanActionAppConfigurator.cons(applicationInfo, context);

        configurator.getBuilder()
                .addResultSerializers(Cf.list(
                        new CompoundJsonPojoResultSerializer(generalBenderMapper, directBenderMapper),
                        new CompoundProtobufResultSerializer()))

                .addParameterBinders(Cf.list(
                        new DataApiAppBinder(),
                        new DataApiUserIdBinder(),
                        new BenderJsonParameterBinder(generalBenderMapper),
                        new DeltaParameterBinder(generalBenderMapper)))

                .addInvocationInterceptors(Cf.list(
                        new ThreadLocalCacheInterceptor(),
                        new AppInfoInvocationInterceptor())
                        .plus(Option.x(proxyInterceptor))
                        .plus(Option.x(proxyBatchInterceptor))
                        .plus(Option.x(rateLimiterInterceptor)))

                .addDispatcherInterceptors(Cf.<ActionDispatcherInterceptor>list()
                        .plus(setUserAndAppInfoInterceptors)
                        .plus(Option.x(securityPlatformInterceptor)))

                .disable(Feature.USE_SECURITY)
        ;

        ActionApp actionApp = configurator.configure();

        if (profileBatchGetAction != null) {
            profileBatchGetAction.setActionDescriptorResolver(actionApp.getActionDescriptorResolver());
            profileBatchGetAction.setExceptionResolver(new ExceptionResolver(configurator.getBuilder().getExceptionHandlers()));
            profileBatchGetAction.setSetUserAndAppInfoInterceptors(Cf.x(setUserAndAppInfoInterceptors));
        }

        return actionApp;
    }
}
