package ru.yandex.chemodan.app.dataapi.web;

import lombok.Setter;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiAppBinder;
import ru.yandex.chemodan.app.dataapi.web.binders.DataApiUserIdBinder;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@Setter
public abstract class DataApiActionBase extends PublicCloneableActionSupport {
    @BindWith(DataApiUserIdBinder.class)
    protected DataApiUserId user;
    @BindWith(DataApiAppBinder.class)
    protected Option<String> app;

    @PathParam(value = "context")
    protected Option<String> restLikeContextStr;

    @RequestParam(value = "context")
    protected Option<String> restLikeContextStrGetParam;

    protected String getRestLikeContext() {
        return restLikeContextStr
                .flatMapO(str -> Option.ofNullable(StringUtils.trimToNull(str)))
                .orElse(restLikeContextStrGetParam)
                .getOrElse("").replace("/", "");
    }
}
