package ru.yandex.chemodan.app.dataapi.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.batch.BatchAllAction;
import ru.yandex.chemodan.app.dataapi.web.batch.BatchGetAction;
import ru.yandex.chemodan.app.dataapi.web.batch.BatchSupport;
import ru.yandex.chemodan.app.dataapi.web.generic.GenericActionsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.web.internal.InternalActionsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.web.platform.PlatformBatchAction;
import ru.yandex.chemodan.app.dataapi.web.profile.ProfileActionsContextConfiguration;
import ru.yandex.chemodan.notifier.GetUnreadNotificationsCountAction;
import ru.yandex.chemodan.notifier.NotifierUnreadCountProvider;
import ru.yandex.chemodan.notifier.NotifierUnreadCountProviderContextConfiguration;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.inside.passport.tvm2.Tvm2;
import ru.yandex.inside.passport.tvm2.web.Tvm2BaseContextConfiguration;
import ru.yandex.misc.thread.ParallelStreamSupplier;

/**
 * @author tolmalev
 */
@Configuration
@Import({
        InternalActionsContextConfiguration.class,
        ProfileActionsContextConfiguration.class,
        GenericActionsContextConfiguration.class,
        NotifierUnreadCountProviderContextConfiguration.class,
        Tvm2BaseContextConfiguration.class,
})
public class DataApiActionsContextConfiguration {

    @Bean
    ParallelStreamSupplier batchExecutorService(
            @Value("${dataapi.batch.max.thread.count}") int threadCount,
            @Value("${dataapi.batch.min.thread.count}") int minCount,
            @Value("${a3.timeOut:-500}") int reqTimeout)
    {
        return ParallelStreamSupplier.builder().minThreadCount(minCount).maxThreadCount(threadCount).invocationTimeoutMs(reqTimeout)
                .threadNameFactory("batchExecutorServiceThread").prestartAllThreads(true).build();
    }

    @Bean
    public BatchSupport batchSupport(ParallelStreamSupplier streamRunner) {
        return new BatchSupport(streamRunner);
    }

    @Bean
    public BatchGetAction batchGetAction(BatchSupport batchSupport) {
        return new BatchGetAction(batchSupport);
    }

    @Bean
    public BatchAllAction batchAllAction(BatchSupport batchSupport) {
        return new BatchAllAction(batchSupport);
    }

    @Bean
    public PlatformBatchAction batchPlatfromAction(BatchSupport batchSupport) {
        return new PlatformBatchAction(batchSupport);
    }

    @Bean
    public ListDatabasesAction listDatabasesAction(DiskDataSource dataApiManager) {
        return new ListDatabasesAction(dataApiManager);
    }

    @Bean
    public GetDatabaseAction getDatastoreAction(DataApiManager dataApiManager) {
        return new GetDatabaseAction(dataApiManager);
    }

    @Bean
    public GetOrCreateDatabaseAction getOrCreateDatabaseAction(DataApiManager dataApiManager) {
        return new GetOrCreateDatabaseAction(dataApiManager);
    }

    @Bean
    public DeleteDatabaseAction deleteDatabaseAction(
            DataApiManager dataApiManager,
            DiskDataSource diskDataSource)
    {
        return new DeleteDatabaseAction(dataApiManager, diskDataSource);
    }

    @Bean
    public DeleteDatabasesAction deleteDatabasesAction(DiskDataSource dataApiManager) {
        return new DeleteDatabasesAction(dataApiManager);
    }

    @Bean
    public GetSnapshotAction getSnapshotAction(DataApiManager dataApiManager, AppSettingsRegistry appSettingsRegistry) {
        return new GetSnapshotAction(dataApiManager, appSettingsRegistry);
    }

    @Bean
    public GetModifiedRecordsAction getModifiedRecordsAction(DiskDataSource dataApiManager) {
        return new GetModifiedRecordsAction(dataApiManager);
    }

    @Bean
    public PutDeltaAction putDeltaAction(DataApiManager dataApiManager) {
        return new PutDeltaAction(dataApiManager);
    }

    @Bean
    public ListDeltasAction listDeltasAction(DataApiManager dataApiManager, AppSettingsRegistry appSettingsRegistry) {
        return new ListDeltasAction(dataApiManager, appSettingsRegistry);
    }

    @Bean
    public PatchDatabaseAction patchDatabaseAction(DataApiManager dataApiManager) {
        return new PatchDatabaseAction(dataApiManager);
    }

    @Bean
    public RegisterUserAction registerUserAction(UserMetaManager userMetaManager) {
        return new RegisterUserAction(userMetaManager);
    }

    @Bean
    public ListAppUsersAction listAppUsersAction(DiskDataSource dataApiManager) {
        return new ListAppUsersAction(dataApiManager);
    }

    @Bean
    public GetUnreadNotificationsCountAction getUnreadNotificationsCountAction(
            NotifierUnreadCountProvider unreadCountProvider)
    {
        return new GetUnreadNotificationsCountAction(unreadCountProvider);
    }

    @Component
    static class BatchInitializer implements ApplicationListener<ContextRefreshedEvent> {

        @Autowired
        BatchSupport batchSupport;
        @Autowired
        ActionApp actionApp;

        @Override public void onApplicationEvent(ContextRefreshedEvent event) {
            batchSupport.setActionApp(actionApp);
        }
    }

    @Bean
    public PostTakeoutAction postTakeoutAction(DataApiManager dataApiManager, DiskDataSource diskDataSource, Tvm2 tvm2) {
        return new PostTakeoutAction(dataApiManager, diskDataSource, tvm2);
    }
}
