package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseAlias;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.api.deltas.DeltasAppliedDatabase;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePojo;
import ru.yandex.chemodan.app.dataapi.web.pojo.ListDeltasResult;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.bind.annotation.PathParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;

import static ru.yandex.chemodan.app.dataapi.web.direct.DirectActionInvocationUtils.isDirectInvocation;

/**
 * @author tolmalev
 */
public abstract class DatabaseAction extends DataApiActionBase {

    @PathParam
    protected String databaseId;

    @SpecialParam
    protected ActionInvocationContext context;

    protected final DataApiManager dataApiManager;

    protected DatabaseAction(DataApiManager dataApiManager) {
        this.dataApiManager = dataApiManager;
    }

    protected void addETagHeaderToResponseIfNeeded(Object result) {
        if (isDirectInvocation(context)) {
            Option<String> etag = extractETagHeaderValue(result);
            if (etag.isPresent()) {
                context.getHttpContext().setHeader("ETag", etag.get());
            }
        }
    }

    private Option<String> extractETagHeaderValue(Object result) {
        long rev;
        if (result instanceof DatabasePojo) {
            rev = ((DatabasePojo) result).rev;
        } else if (result instanceof Snapshot) {
            rev = ((Snapshot) result).database.rev;
        } else if (result instanceof ListDeltasResult) {
            rev = ((ListDeltasResult) result).currentDatabaseRev;
        } else if (result instanceof Database) {
            rev = ((Database) result).rev;
        } else if (result instanceof DeltasAppliedDatabase) {
            rev = ((DeltasAppliedDatabase) result).database.rev;
        } else {
            return Option.empty();
        }
        return Option.of(String.valueOf(rev));
    }

    protected DatabaseRef databaseRef() {
        return databaseAlias()
                .dbRef();
    }

    private DatabaseAlias databaseAlias() {
        String contextStr = getRestLikeContext();
        if (contextStr.equals("user")) {
            return DatabaseAlias.parse(Option.empty(), databaseId);
        } else {
            return DatabaseAlias.parse(app, databaseId);
        }
    }

    protected UserDatabaseSpec databaseSpec() {
        return UserDatabaseSpec.fromUserAndAlias(user, databaseAlias());
    }
}
