package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public class DatabaseNotFoundException extends NotFoundException {
    public final boolean dueToUser;

    private DatabaseNotFoundException(DatabaseRef databaseRef, String reason, boolean dueToUser) {
        this(databaseRef, Option.of(reason), dueToUser);
    }

    private DatabaseNotFoundException(DatabaseRef databaseRef, Option<String> reasonO, boolean dueToUser) {
        super("Database not found " + databaseRef + reasonO.getOrElse(""));
        this.dueToUser = dueToUser;
    }

    public static DatabaseNotFoundException consDueToUser(DataApiUserId user, DatabaseRef databaseRef) {
        return new DatabaseNotFoundException(databaseRef, "since user " + user + " is not registered", true);
    }

    public static DatabaseNotFoundException cons(DatabaseRef databaseRef) {
        return new DatabaseNotFoundException(databaseRef, Option.empty(), false);
    }
}
