package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "delete-database", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Удалить базу данных")
@Path(value = "/{context:.*/?}databases/{databaseId}", methods = HttpMethod.DELETE)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class DeleteDatabaseAction extends DatabaseAction {
    final DiskDataSource diskDataSource;

    protected DeleteDatabaseAction(DataApiManager dataApiManager, DiskDataSource diskDataSource) {
        super(dataApiManager);
        this.diskDataSource = diskDataSource;
    }

    @Override
    public Object execute() {
        diskDataSource.deleteDatabases(user, databaseRef());
        return new OkPojo();
    }
}
