package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseDeletionMode;
import ru.yandex.chemodan.app.dataapi.api.db.filter.DatabasesFilterSource;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRefs;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author dbrylev
 */
@Action(
        value = @Action.Alias(value = "delete-databases", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Удалить базы данных приложения")
@Path(value = "/{context:.*/?}databases", methods = HttpMethod.DELETE)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class DeleteDatabasesAction extends DataApiActionBase {
    private static final DatabaseDeletionMode DELETION_MODE = DatabaseDeletionMode.MARK_DELETED;

    @RequestParam(value = "databaseId", required = false)
    private ListF<String> databaseIds;

    private final DiskDataSource dataApiManager;

    public DeleteDatabasesAction(DiskDataSource dataApiManager) {
        this.dataApiManager = dataApiManager;
    }

    @Override
    public Object execute() {
        deleteDatabases();
        return new OkPojo();
    }

    private void deleteDatabases() {
        dataApiManager.deleteDatabases(user, filter(), DELETION_MODE);
    }

    private DatabasesFilterSource filter() {
        return databaseIds.isNotEmpty()
                ? new DatabaseRefs(app, databaseIds)
                : DatabaseContext.cons(app);
    }
}
