package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.chemodan.app.dataapi.api.data.protobuf.ProtobufDataUtils;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.util.SingleOrList;
import ru.yandex.commune.a3.action.UnsupportedMediaTypeException;
import ru.yandex.commune.a3.action.invoke.ActionInvocationContext;
import ru.yandex.commune.a3.action.parameter.IllegalParameterException;
import ru.yandex.commune.a3.action.parameter.ParameterDescriptor;
import ru.yandex.commune.a3.action.parameter.WebRequest;
import ru.yandex.commune.a3.action.parameter.bind.ParameterBinder;
import ru.yandex.commune.a3.action.result.type.MediaType;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.parse.BenderParserUtils;
import ru.yandex.misc.io.SimpleInputStreamSource;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.web.servlet.HttpServletRequestX;

/**
 * @author tolmalev
 */
public class DeltaParameterBinder implements ParameterBinder {
    private static final Logger logger = LoggerFactory.getLogger(DeltaParameterBinder.class);

    private final BenderMapper mapper;

    public DeltaParameterBinder(BenderMapper mapper) {
        this.mapper = mapper;
    }

    @Override
    public Object createAndBind(WebRequest request, ActionInvocationContext invocationContext,
            ParameterDescriptor descriptor)
    {
        String contentType = request.getHttpServletRequest().getContentType();
        Class<?> clazz = descriptor.getParameterType().getRawType().erasure().getClazz();

        try {
            if (MediaType.APPLICATION_JSON.includes(contentType)) {
                BenderJsonNode node = BenderParserUtils.json(getStreamSource(request.getHttpServletRequest()));
                if (clazz.isAssignableFrom(SingleOrList.class)) {
                    return node.isArray()
                            ? SingleOrList.list(node.getArrayElements().map(child -> mapper.parseJson(Delta.class, child)))
                            : SingleOrList.single(mapper.parseJson(Delta.class, node));
                }
                return mapper.parseJson(clazz, getStreamSource(request.getHttpServletRequest()));
            } else if (MediaType.APPLICATION_X_PROTOBUF.includes(contentType)) {
                Delta delta = ProtobufDataUtils.parseDelta(getStreamSource(request.getHttpServletRequest()));

                return clazz.isAssignableFrom(SingleOrList.class)
                        ? SingleOrList.single(delta)
                        : delta;
            }
        } catch (RuntimeException e) {
            logger.error("Can't parse delta from input: {}", e);
            throw new IllegalParameterException("delta", "Can't parse delta");
        }
        throw new UnsupportedMediaTypeException(MediaType.APPLICATION_JSON,
                MediaType.APPLICATION_XML, MediaType.APPLICATION_X_PROTOBUF);
    }

    private static SimpleInputStreamSource getStreamSource(HttpServletRequestX request) {
        return new SimpleInputStreamSource(request.getInputStreamX());
    }
}
