package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.misc.db.masterSlave.MasterSlaveContextHolder;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "get-database", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить существущую базу данных")
@Path(value = "/{context:.*/?}databases/{databaseId}", methods = HttpMethod.GET)
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetDatabaseAction extends DatabaseAction {

    protected GetDatabaseAction(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    @Override
    public DatabasePojo execute() {
        DatabasePojo result;
        try {
            result = new DatabasePojo(dataApiManager.getDatabase(databaseSpec()));
        } catch (NotFoundException e) {
            result = MasterSlaveContextHolder.withPolicy(MasterSlavePolicy.R_M,
                    () -> new DatabasePojo(dataApiManager.getDatabase(databaseSpec()))
            );
        }
        addETagHeaderToResponseIfNeeded(result);
        return result;
    }
}
