package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.db.revision.DatabaseRefRevisions;
import ru.yandex.chemodan.app.dataapi.api.db.revision.DatabaseRevision;
import ru.yandex.chemodan.app.dataapi.api.deltas.ModifiedRecordsPojo;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author dbrylev
 */
@Action(
        value = @Action.Alias(value = "get-modified-records", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить измененные объекты баз данных приложения")
@Path(value = "/modified-records", methods = HttpMethod.POST)
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetModifiedRecordsAction extends DataApiActionBase {

    private final DiskDataSource dataApiManager;

    public GetModifiedRecordsAction(DiskDataSource dataApiManager) {
        this.dataApiManager = dataApiManager;
    }

    @BindWith(BenderJsonParameterBinder.class)
    private RequestData data;
    @RequestParam
    protected Option<String> app;

    @Override
    public ModifiedRecordsPojo execute() throws Exception {
        return dataApiManager.getRecordsModifiedSinceRevisions(
                user,
                new DatabaseRefRevisions(DatabaseContext.cons(app), data.revisions),
                data.limit
        );
    }

    @BenderBindAllFields
    public static class RequestData {
        public final ListF<DatabaseRevision> revisions;
        public final Option<Integer> limit;

        public RequestData(ListF<DatabaseRevision> revisions, Option<Integer> limit) {
            this.revisions = revisions;
            this.limit = limit;
        }
    }
}
