package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "get-or-create-database", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить базу или создать, если она не существовала")
@Path(value = "/{context:.*/?}databases/{databaseId}", methods = HttpMethod.PUT)
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class GetOrCreateDatabaseAction extends DatabaseAction {

    protected GetOrCreateDatabaseAction(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    @Override
    public DatabasePojo execute() {
        return consPojo(dataApiManager.getOrCreateDatabase(databaseSpec()));
    }

    private DatabasePojo consPojo(Database database) {
        if (database.isNew) {
            context.getHttpContext().setStatusCode(HttpStatus.SC_201_CREATED);
        }

        DatabasePojo result = new DatabasePojo(database);
        addETagHeaderToResponseIfNeeded(result);
        return result;
    }
}
