package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.filter.RecordsFilter;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojo;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestListParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlaveContextHolder;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "get-snapshot", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить снапшот базы или конкретных таблиц")
@Path(value = "/{context:.*/?}databases/{databaseId}/snapshot", methods = HttpMethod.GET)
public class GetSnapshotAction extends DatabaseAction {

    @RequestParam
    private Option<Integer> offset;
    @RequestParam
    private Option<Integer> limit;

    @RequestListParam(required = false)
    private ListF<String> collectionId;

    private final AppSettingsRegistry appSettingsRegistry;

    protected GetSnapshotAction(DataApiManager dataApiManager, AppSettingsRegistry appSettingsRegistry) {
        super(dataApiManager);
        this.appSettingsRegistry = appSettingsRegistry;
    }

    @Override
    public SnapshotPojo execute() {
        Snapshot result = getSnapshotQueryingMasterIfNotFound();
        addETagHeaderToResponseIfNeeded(result);
        return result.toPojo();
    }

    private Snapshot getSnapshotQueryingMasterIfNotFound() {
        MasterSlavePolicy policy = getMasterSlavePolicy();
        if (policy == MasterSlavePolicy.R_M) {
            return MasterSlaveContextHolder.withPolicy(policy, this::getSnapshot);
        } else {
            try {
                return MasterSlaveContextHolder.withPolicy(policy, this::getSnapshot);
            } catch (NotFoundException e) {
                return MasterSlaveContextHolder.withPolicy(MasterSlavePolicy.R_M, this::getSnapshot);
            }
        }
    }

    private MasterSlavePolicy getMasterSlavePolicy() {
        return appSettingsRegistry
                .getSettings(app)
                .getSettingsByDbId(Option.of(databaseId))
                .snapshotPolicy;
    }

    private Snapshot getSnapshot() {
        return dataApiManager.getSnapshot(databaseSpec(), getFilter());
    }

    private RecordsFilter getFilter() {
        return collectionId.isNotEmpty()
                ? RecordsFilter.DEFAULT.withCollectionIds(collectionId).withLimits(ActionUtils.getLimits(limit, offset))
                : RecordsFilter.DEFAULT.withLimits(ActionUtils.getLimits(limit, offset));
    }
}
