package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.chemodan.app.dataapi.ErrorNames;
import ru.yandex.chemodan.util.exception.A3ExceptionWithNoStackTrace;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author dbrylev
 */
public class InaccessibleYPathException extends A3ExceptionWithNoStackTrace implements HttpStatusCodeSource {

    public InaccessibleYPathException(String ypath, Throwable cause) {
        this(ypath, ExceptionUtils.getAllMessages(cause));
    }

    public InaccessibleYPathException(String ypath, String cause) {
        super(ErrorNames.INACCESSIBLE_YPATH, "Cannot access requested ypath " + ypath + ": " + cause);
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_400_BAD_REQUEST;
    }
}
