package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.user.UsersIterationKey;
import ru.yandex.chemodan.app.dataapi.api.user.UsersPojo;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.web.convert.ConverterToUsersIterationKey;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.ValidateParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.support.PublicCloneableActionSupport;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author dbrylev
 */
@Action(
        value = @Action.Alias(value = "list-users", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить список пользователей приложения")
@Path("/users")
@WithMasterSlavePolicy(MasterSlavePolicy.R_ANY)
public class ListAppUsersAction extends PublicCloneableActionSupport {
    private static final int DEFAULT_LIMIT = 1000;
    private static final int MAX_LIMIT = 100_000;

    @RequestParam
    private Option<String> app;
    @RequestParam
    private Option<String> databaseId;
    @RequestParam
    private Option<Integer> limit;
    @RequestParam(customConverter = ConverterToUsersIterationKey.class)
    private Option<UsersIterationKey> iterationKey;

    private final DiskDataSource dataApiManager;

    public ListAppUsersAction(DiskDataSource dataApiManager) {
        this.dataApiManager = dataApiManager;
    }

    @Override
    public UsersPojo execute() {
        ValidateParam.gt("limit", limit.getOrElse(1), 0);
        ValidateParam.le("limit", limit.getOrElse(1), MAX_LIMIT);
        return dataApiManager.getAppUsers(
                DatabaseContext.cons(app), databaseId, iterationKey, limit.getOrElse(DEFAULT_LIMIT));
    }
}
