package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.web.pojo.ListDatabasesPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.ValidateParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "list-databases", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Получить список баз данных")
@Path("/{context:.*/?}databases")
@WithMasterSlavePolicy(MasterSlavePolicy.R_M)
public class ListDatabasesAction extends DataApiActionBase {
    private static final int DEFAULT_LIMIT = 100;
    private static final int DEFAULT_OFFSET = 0;

    @RequestParam
    private Option<Integer> limit;
    @RequestParam
    private Option<Integer> offset;

    private final DiskDataSource dataApiManager;

    public ListDatabasesAction(DiskDataSource dataApiManager) {
        this.dataApiManager = dataApiManager;
    }

    @Override
    public ListDatabasesPojo execute() {
        ListF<Database> databases = dataApiManager.listDatabases(user, getDbContext());

        int total = databases.size();
        int limitInt = limit.getOrElse(DEFAULT_LIMIT);
        int offsetInt = offset.getOrElse(DEFAULT_OFFSET);

        if (limit.isPresent() && offset.isPresent()) {
            ValidateParam.ge("limit", limitInt, 0);
            ValidateParam.ge("offset", offsetInt, 0);
            ValidateParam.le("offset", offsetInt, total);

            databases = databases.subList(offsetInt, Math.min(total, offsetInt + limitInt));
        }

        return new ListDatabasesPojo(databases, total, limitInt, offsetInt);
    }

    private DatabaseContext getDbContext() {
        return DatabaseContext.cons(app);
    }
}
