package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.dataapi.utils.HttpStatusCodeSourceWithErrorLevel;
import ru.yandex.chemodan.util.exception.A3ExceptionWithNoStackTrace;
import ru.yandex.commune.a3.action.result.error.CommonErrorNames;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class NotFoundException extends A3ExceptionWithNoStackTrace implements HttpStatusCodeSourceWithErrorLevel {
    public NotFoundException(String message) {
        super(CommonErrorNames.NOT_FOUND, message);
    }

    public static NotFoundException consDeltaNotFound(long rev) {
        return new NotFoundException("Delta#" + rev + " not found");
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_404_NOT_FOUND;
    }

    public static Function0<NotFoundException> consF(final String message) {
        return () -> new NotFoundException(message);
    }

}
