package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePatchPojo;
import ru.yandex.chemodan.app.dataapi.web.pojo.DatabasePojo;
import ru.yandex.chemodan.util.web.BenderJsonParameterBinder;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "patch-database", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Изменить базу")
@Path(value = "/{context:.*/?}databases/{databaseId}", methods = HttpMethod.PATCH)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class PatchDatabaseAction extends DatabaseAction {

    @BindWith(value = BenderJsonParameterBinder.class)
    private DatabasePatchPojo patch;

    protected PatchDatabaseAction(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    @Override
    public DatabasePojo execute() throws Exception {
        DatabasePojo result;
        if (patch.removeDescription.isSome(true)) {
            result = new DatabasePojo(dataApiManager.setDatabaseDescription(databaseSpec(), Option.empty()));
        } else if (patch.description.isPresent()) {
            result = new DatabasePojo(dataApiManager.setDatabaseDescription(databaseSpec(), patch.description));
        } else {
            result = new DatabasePojo(dataApiManager.getDatabase(databaseSpec()));
        }
        addETagHeaderToResponseIfNeeded(result);
        return result;
    }
}
