package ru.yandex.chemodan.app.dataapi.web;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.core.dao.DataApiShardResolver;
import ru.yandex.chemodan.app.dataapi.web.rest.MasterDcHostResolverSharpei;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyBatchInterceptor;
import ru.yandex.chemodan.app.dataapi.web.rest.ProxyInterceptor;
import ru.yandex.chemodan.boot.value.OverridableValuePrefix;
import ru.yandex.chemodan.http.proxy.AccelProxy;
import ru.yandex.chemodan.http.proxy.HttpProxy;
import ru.yandex.chemodan.http.proxy.MasterDcHostResolver;
import ru.yandex.chemodan.http.proxy.ProxyClient;
import ru.yandex.chemodan.http.proxy.ProxyManager;
import ru.yandex.chemodan.util.http.CachedServletRequestFilter;
import ru.yandex.chemodan.util.http.HttpClientConfigurator;
import ru.yandex.commune.alive2.AliveAppInfo;
import ru.yandex.commune.alive2.AliveAppsContextConfiguration;
import ru.yandex.commune.alive2.AliveAppsHolder;
import ru.yandex.commune.db.shard2.ShardManager2;

@Configuration
@Import({
        AliveAppsContextConfiguration.class
})
public class ProxyConfiguration {

    @Bean
    MasterDcHostResolver masterDcHostResolver(ShardManager2 dataShardManager,
            DataApiShardResolver shardResolver)
    {
        return new MasterDcHostResolverSharpei(dataShardManager, shardResolver);
    }

    @Bean
    @Qualifier("proxy")
    @OverridableValuePrefix("proxy")
    public HttpClientConfigurator proxyHttpClientConfigurator() {
        return new HttpClientConfigurator();
    }

    @Bean
    ProxyManager proxyManager(AliveAppsHolder aliveAppsHolder,
                              AliveAppInfo aliveAppInfo,
                              MasterDcHostResolver masterDcHostResolver,
                              @Qualifier("proxy") HttpClientConfigurator httpClientConfigurator,
                              @Value("${dataapi.use.nginx.accel.proxy:-true}") boolean useAccelProxy,
                              @Value("${dataapi.http.proxy.retry.count:-0}") int retryCount) {
        if (useAccelProxy) {
            return new ProxyManager(masterDcHostResolver,
                    new AccelProxy(),
                    aliveAppsHolder,
                    aliveAppInfo);
        } else {
            return new ProxyManager(masterDcHostResolver,
                    new HttpProxy(new ProxyClient(httpClientConfigurator.configure())),
                    aliveAppsHolder,
                    aliveAppInfo,
                    retryCount);
        }
    }

    @Bean
    public CachedServletRequestFilter cachedServletRequestFilter() {
        return new CachedServletRequestFilter();
    }

    @Bean
    ProxyInterceptor proxyInterceptor(ProxyManager proxyManager) {
        return new ProxyInterceptor(proxyManager);
    }

    @Bean
    ProxyBatchInterceptor proxyBatchInterceptor(ProxyManager proxyManager) {
        return new ProxyBatchInterceptor(proxyManager);
    }
}
