package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.OutdatedChangeException;
import ru.yandex.chemodan.app.dataapi.api.deltas.RevisionCheckMode;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.app.dataapi.web.pojo.ListDeltasResult;
import ru.yandex.chemodan.util.SingleOrList;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.BindWith;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.a3.action.parameter.bind.annotation.SpecialParam;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.web.servlet.HttpServletResponseX;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "put-delta", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Применить дельту или дельты")
@Path(value = "/{context:.*/?}databases/{databaseId}/{tail:(diffs|deltas)}", methods = HttpMethod.PUT)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
//@InterceptWith(value = ProxyInterceptor.class)
public class PutDeltaAction extends DatabaseAction {

    @RequestParam
    private long rev;
    @BindWith(DeltaParameterBinder.class)
    private SingleOrList<Delta> deltas;
    @RequestParam
    private Option<RevisionCheckMode> revisionCheck;

    @SpecialParam
    private HttpServletResponseX resp;

    public PutDeltaAction(DataApiManager dataApiManager) {
        super(dataApiManager);
    }

    @Override
    public Object execute() throws Exception {
        Object result = applyDeltasOrListNew();

        if (result instanceof ListDeltasResult) {
            resp.setStatus(HttpStatus.SC_409_CONFLICT);
        }

        addETagHeaderToResponseIfNeeded(result);
        return result;
    }

    private Object applyDeltasOrListNew() {
        UserDatabaseSpec databaseSpec = databaseSpec();
        try {
            RevisionCheckMode revCheck = revisionCheck.getOrElse(RevisionCheckMode.WHOLE_DATABASE);
            if (deltas.isSingle()) {
                return dataApiManager.applyDelta(databaseSpec, rev, revCheck, deltas.getSingle());
            } else {
                return dataApiManager.applyDeltas(databaseSpec, rev, revCheck, deltas.getList());
            }
        } catch (OutdatedChangeException e) {
            if (dataApiManager.isNoKeepDeltas(databaseSpec)) {
                throw new DeltasGoneException();
            }

            return listNewDeltas();
        }
    }

    private ListDeltasResult listNewDeltas() {
        ListF<Delta> deltas = dataApiManager.listDeltas(databaseSpec(), rev, Integer.MAX_VALUE);

        long requiredRev = rev;
        for (Delta delta : deltas) {
            if (requiredRev != delta.rev.get()) {
                throw new DeltasGoneException();
            }
            requiredRev++;
        }

        // Hack for old deltas, saved without new revision
        deltas = Delta.addTargetRevIfMissing(deltas);

        return new ListDeltasResult(deltas.size(), deltas, requiredRev, Integer.MAX_VALUE);
    }
}
