package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.util.exception.A3ExceptionWithStatus;
import ru.yandex.commune.a3.action.result.error.ErrorLogLevelSource;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Level;

/**
 * @author tolmalev
 */
public class ReadonlyException extends A3ExceptionWithStatus implements ErrorLogLevelSource {
    public ReadonlyException(DataApiUserId uid) {
        super("user-read-only", "User is read only: " + uid, HttpStatus.SC_503_SERVICE_UNAVAILABLE);
    }

    @Override
    public Level getErrorLogLevel() {
        return Level.WARN;
    }
}
