package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.util.web.OkPojo;
import ru.yandex.commune.a3.action.Action;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.misc.db.masterSlave.MasterSlavePolicy;
import ru.yandex.misc.db.masterSlave.WithMasterSlavePolicy;

/**
 * @author tolmalev
 */
@Action(
        value = @Action.Alias(value = "register-user", namespace = ru.yandex.chemodan.util.web.NS.API),
        description = "Зарегистрировать пользователя в Data-Api")
@Path(value = "/register_user", methods = HttpMethod.PUT)
@WithMasterSlavePolicy(MasterSlavePolicy.RW_M)
public class RegisterUserAction extends DataApiActionBase {

    private final UserMetaManager userMetaManager;

    public RegisterUserAction(UserMetaManager userMetaManager) {
        this.userMetaManager = userMetaManager;
    }

    @Override
    public Object execute() throws Exception {
        userMetaManager.registerIfNotExists(user);
        return new OkPojo();
    }
}
