package ru.yandex.chemodan.app.dataapi.web;

import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.commune.a3.action.A3Exception;
import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.misc.io.http.HttpStatus;

/**
 * @author tolmalev
 */
public class UserNotFoundException extends A3Exception implements HttpStatusCodeSource {
    public UserNotFoundException(DataApiUserId userId) {
        super(ru.yandex.chemodan.util.web.ErrorNames.USER_NOT_FOUND, "User not found: " + userId);
    }

    @Override
    public int getHttpStatusCode() {
        return HttpStatus.SC_500_INTERNAL_SERVER_ERROR;
    }

    public static Function0<UserNotFoundException> consF(final DataApiUserId userId) {
        return () -> new UserNotFoundException(userId);
    }
}
