package ru.yandex.chemodan.app.dataapi.web.admin;

import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.lang.CamelWords;

/**
 * @author yashunsky
 */
public enum AccessLevel implements StringEnum{
    VIEW_META("Просмотр мета-информации базы", "View database's meta"),
    VIEW_CONTENT("Просмотр содержимого базы", "View database's content"),
    EDIT("Изменение базы", "Edit database");

    public final String ruDescription;
    public final String enDescription;

    AccessLevel(String ruDescription, String enDescription) {
        this.ruDescription = ruDescription;
        this.enDescription = enDescription;
    }

    public boolean contains(AccessLevel accessLevel) {
        return this.compareTo(accessLevel) >= 0;
    }

    public String toDbValue() { return CamelWords.parse(this.name()).toDbName(); }

    @Override
    public String value() {
        return toDbValue();
    }
}
