<xsl:stylesheet version="2.0"
                xmlns:ya="urn:yandex-functions"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        >

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/type-settings/common.js"/>
        <script type="text/javascript" src="/z/r/type-settings/jquery.confirm.min.js"/>
        <script type="text/javascript">
            function removeAppSettings(type, appName, databaseId) {
                $.confirm({
                    text: "Are you sure you want to delete settings for type " + type + " app " + appName + " database " + databaseId + "?",
                    title: "Confirmation required",
                    confirm: function(button) {
                        $.ajax({
                            url: '/z/access-rate-limits-settings/remove?type=' + type + '&amp;app-name=' + appName + '&amp;databaseId=' + databaseId,
                            type: 'POST'
                        }).done(function() {
                            location.reload();
                        })
                    },
                    cancel: function(button) {
                        // nothing to do
                    },
                    confirmButton: "Yes",
                    cancelButton: "No",
                    //post: true,
                    confirmButtonClass: "btn-danger",
                    cancelButtonClass: "btn-default",
                    dialogClass: "modal-dialog modal-lg" // Bootstrap classes for large modal
                });
            }
            $('.edit-link').click(function() {
                $(this).parents('.view-edit-container')
                    .find('.view').hide().end()
                    .find('.edit').show().end();
                return false;
            });
            $('.cancel-button').click(function() {
                $(this).parents('.view-edit-container')
                    .find('.edit').hide().end()
                    .find('.view').show().end();
                return false;
            });
            $('.view-edit-container .edit').hide();
        </script>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <xsl:if test="elements/element[type='by-client']">
                    <h2>
                        By client app
                    </h2>
                    <xsl:for-each-group select="elements/element[type='by-client']" group-by="app">
                        <xsl:sort select="database-id"/>

                        <table class="table table-striped table-condensed table-bordered">
                            <tr>
                                <th>
                                    App
                                </th>
                                <th>
                                    Database
                                </th>
                                <th width="20%">
                                    Threads limit
                                </th>
                                <th width="90%"/>
                            </tr>
                            <xsl:apply-templates select="current-group()"/>
                        </table>
                    </xsl:for-each-group>
                </xsl:if>

                <xsl:if test="elements/element[type='by-host']">
                    <h2>
                        By host app
                    </h2>
                    <xsl:for-each-group select="elements/element[type='by-host']" group-by="app">
                        <xsl:sort select="database-id"/>
                        <table class="table table-striped table-condensed table-bordered">
                            <tr>
                                <th>
                                    App
                                </th>
                                <th>
                                    Database
                                </th>
                                <th width="20%">
                                    Threads limit
                                </th>
                                <th width="90%"/>
                            </tr>
                            <xsl:apply-templates select="current-group()"/>
                        </table>
                    </xsl:for-each-group>
                </xsl:if>

                <br/>
                <br/>
                <br/>
                <h2>Добавить новую настройку</h2>

                <form method="POST" action="/z/access-rate-limits-settings/replace">
                    <div class="form-group">
                        <label for="snapshot-policy">Type:</label>
                        <select class="form-control" name="type">
                            <option>by-host</option>
                            <option>by-client</option>
                        </select>

                        <label for="app-name">App Name:</label>
                        <input class="form-control" name="app-name" id="app-name" type="text" placeholder="global"/>
                        <label for="database-id">Database Id:</label>
                        <input class="form-control" name="database-id" id="database-id" type="text" placeholder="*"/>

                        <label for="threads-limit">Threads limit:</label>
                        <input class="form-control" name="threads-limit" id="threads-limit" type="number" placeholder="100"/>
                    </div>
                    <input type="submit" class="btn btn-default" value="Replace"/>
                </form>

            </div>
        </div>

    </xsl:template>

    <xsl:template match="element">
        <tr class="view-edit-container">
            <td>
                <xsl:value-of select="app"/>
            </td>
            <td>
                <xsl:value-of select="database-id"/>
            </td>
            <td>
                <xsl:value-of select="threads-limit"/>
            </td>
            <td class="edit" colspan="3" style="display: none;">
                <form method="POST" action="/z/access-rate-limits-settings/replace" class="form-group" style="margin-left: 15px">
                    <input type="hidden" name="app-name" value="{app}"/>
                    <input type="hidden" name="database-id" value="{database-id}"/>
                    <input type="hidden" name="type" value="{type}"/>

                    <label for="threads-limit">Threads limit:</label>
                    <input class="form-control" name="threads-limit" id="threads-limit" type="number" value="{threads-limit}" placeholder="100"/>

                    <input type="submit" class="btn btn-default btn-sm" value="Update"/>
                    <xsl:text>&#160;</xsl:text>
                    <input type="button" class="cancel-button btn btn-sm" value="Cancel"/>
                </form>
            </td>
            <td class="view">
                <a href="#" class="edit-link">Редактировать</a>
                <xsl:text>&#160;</xsl:text>
                <a href="#" onclick="removeAppSettings('{encode-for-uri(type)}', '{encode-for-uri(app)}', '{encode-for-uri(database-id)}');">Удалить</a>
            </td>
        </tr>
    </xsl:template>

</xsl:stylesheet>

