package ru.yandex.chemodan.app.dataapi.web.admin;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.limiter.access.AccessRateLimits;
import ru.yandex.chemodan.app.dataapi.core.limiter.access.AccessRateLimitsRegistry;
import ru.yandex.commune.a3.action.ActionContainer;
import ru.yandex.commune.a3.action.HttpMethod;
import ru.yandex.commune.a3.action.Path;
import ru.yandex.commune.a3.action.parameter.bind.annotation.RequestParam;
import ru.yandex.commune.admin.z.ZAction;
import ru.yandex.commune.admin.z.ZRedirectException;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.bender.annotation.BenderPart;
import ru.yandex.misc.bender.annotation.XmlRootElement;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author tolmalev
 */
@ActionContainer
public class AccessRateLimitsAdminPage {
    private final AccessRateLimitsRegistry registry;

    public AccessRateLimitsAdminPage(AccessRateLimitsRegistry registry) {
        this.registry = registry;
    }

    @ZAction(defaultAction = true)
    @Path("/access-rate-limits-settings")
    public AccessRateLimitsListPojo index() {
        return new AccessRateLimitsListPojo(registry.getAll().toList());
    }

    @Path(value = "/access-rate-limits-settings/replace", methods = HttpMethod.POST)
    public void replaceSettings(
            @RequestParam("appName") String appName,
            @RequestParam("databaseId") String dbId,
            @RequestParam("type") AccessRateLimits.Type type,
            @RequestParam("threadsLimit") int threadsLimit)
    {
        registry.put(new AccessRateLimits(type, appName, Option.ofNullable(StringUtils.trimToNull(dbId)), threadsLimit));

        throw new ZRedirectException("/access-rate-limits-settings");
    }

    @Path(value = "/access-rate-limits-settings/remove", methods = HttpMethod.POST)
    public void removeSettings(
            @RequestParam("appName") String appName,
            @RequestParam("databaseId") String dbId,
            @RequestParam("type") AccessRateLimits.Type type)
    {
        registry.remove(AccessRateLimitsRegistry.id(type, appName, Option.ofNullable(StringUtils.trimToNull(dbId))));

        throw new ZRedirectException("/access-rate-limits-settings");
    }

    @XmlRootElement(name = "content")
    @BenderBindAllFields
    private static class AccessRateLimitsListPojo {
        @BenderPart(name = "element", wrapperName = "elements")
        public final ListF<AccessRateLimits> list;

        private AccessRateLimitsListPojo(ListF<AccessRateLimits> list) {
            this.list = list;
        }
    }
}
