<xsl:stylesheet version="2.0"
                xmlns:ya="urn:yandex-functions"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        >

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="additional-script">
        <script type="text/javascript" src="/z/r/type-settings/common.js"/>
        <script type="text/javascript" src="/z/r/type-settings/jquery.confirm.min.js"/>
        <script type="text/javascript">
            function removeAppSettings(appName, databaseId) {
                $.confirm({
                    text: "Are you sure you want to delete settings for app " + appName + " database " + databaseId + "?",
                    title: "Confirmation required",
                    confirm: function(button) {
                        $.ajax({
                            url: '/z/app-settings/delete?app-name=' + appName + '&amp;databaseId=' + databaseId,
                            type: 'POST'
                        }).done(function() {
                            location.reload();
                        })
                    },
                    cancel: function(button) {
                        // nothing to do
                    },
                    confirmButton: "Yes",
                    cancelButton: "No",
                    //post: true,
                    confirmButtonClass: "btn-danger",
                    cancelButtonClass: "btn-default",
                    dialogClass: "modal-dialog modal-lg" // Bootstrap classes for large modal
                });
            }
            $('.edit-link').click(function() {
                $(this).parents('.view-edit-container')
                    .find('.view').hide().end()
                    .find('.edit').show().end();
                return false;
            });
            $('.cancel-button').click(function() {
                $(this).parents('.view-edit-container')
                    .find('.edit').hide().end()
                    .find('.view').show().end();
                return false;
            });
            $('.view-edit-container .edit').hide();
        </script>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="error"/>
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <div id="main-content">
            <div class="container">
                <table class="table table-striped table-condensed table-bordered">
                    <caption>AppData settings</caption>
                    <tr>
                        <th>App Name</th>
                        <th>Database Id</th>
                        <th>Кэш-ть</th>
                        <th>Без дельт</th>
                        <th>Без Xiva</th>
                        <th>Дамп в YT</th>
                        <th>Snapshot policy</th>
                        <th>Deltas policy</th>
                        <th>Макс. размер базы</th>
                        <th>Макс. объектов в базе</th>
                        <th>Имя log-type для LB</th>
                        <th>Действия</th>
                    </tr>
                    <xsl:for-each select="elements/element">
                        <tr class="view-edit-container">
                            <td>
                                <xsl:if test="not(app-name)"><span style="color: #777">global</span></xsl:if>
                                <xsl:if test="app-name"><xsl:value-of select="app-name"/></xsl:if>
                            </td>
                            <td>
                                <xsl:if test="not(database-id)"><span style="color: #777">*</span></xsl:if>
                                <xsl:if test="database-id"><xsl:value-of select="database-id"/></xsl:if>
                            </td>
                            <td class="view" style="width: 10%">
                                <xsl:if test="use-cache = 'true'">✓</xsl:if>
                            </td>
                            <td class="view" style="width: 10%">
                                <xsl:if test="no-keep-deltas = 'true'">✓</xsl:if>
                            </td>
                            <td class="view" style="width: 10%">
                                <xsl:if test="no-xiva = 'true'">✓</xsl:if>
                            </td>
                            <td class="view" style="width: 10%">
                                <xsl:if test="have-dump-in-yt = 'true'">✓</xsl:if>
                            </td>
                            <td class="view" style="width: 10%">
                                <xsl:value-of select="snapshot-policy"/>
                            </td>
                            <td class="view" style="width: 10%">
                                <xsl:value-of select="list-deltas-policy"/>
                            </td>
                            <td class="view" style="width: 10%">
                                <xsl:value-of select="database-size-limit"/>
                            </td>
                            <td class="view" style="width: 10%">
                                <xsl:value-of select="database-records-count-limit"/>
                            </td>
                            <td class="view" style="width: 10%">
                                <xsl:value-of select="lb-push-log-type-name"/>
                            </td>
                            <td class="view">
                                <a href="#" class="edit-link">Редактировать</a>
                                <xsl:text>&#160;</xsl:text>
                                <a href="#" onclick="removeAppSettings('{encode-for-uri(app-name)}', '{encode-for-uri(database-id)}');">Удалить</a>
                            </td>
                            <td class="edit" colspan="10" style="display: none;">
                                <form method="POST" action="/z/app-settings/replace" class="form-group" style="margin-left: 15px">
                                    <input type="hidden" name="app-name" value="{app-name}"/>
                                    <input type="hidden" name="database-id" value="{database-id}"/>

                                    <xsl:copy-of select="ya:checkbox('use-cache', 'Кэшировать', use-cache = 'true')"/>
                                    <xsl:copy-of select="ya:checkbox('no-keep-deltas', 'Не хранить дельты', no-keep-deltas = 'true')"/>
                                    <xsl:copy-of select="ya:checkbox('no-xiva', 'Не пушить в Xiva', no-xiva = 'true')"/>
                                    <xsl:copy-of select="ya:checkbox('have-dump-in-yt', 'Дампить в YT', have-dump-in-yt = 'true')"/>

                                    <label for="snapshot-policy">Snapshot policy:</label>
                                    <select class="form-control" name="snapshot-policy">
                                        <option>
                                            <xsl:if test="snapshot-policy='rw-m'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            RW_M
                                        </option>
                                        <option>
                                            <xsl:if test="snapshot-policy='r-m'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            R_M
                                        </option>
                                        <option>
                                            <xsl:if test="snapshot-policy = 'r-sm'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            R_SM
                                        </option>
                                        <option>
                                            <xsl:if test="snapshot-policy = 'r-ms'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            R_MS
                                        </option>
                                        <option>
                                            <xsl:if test="snapshot-policy = 'r-any'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            R_ANY
                                        </option>
                                        <option>
                                            <xsl:if test="snapshot-policy = 'r-s'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            R_S
                                        </option>
                                        <option>
                                            <xsl:if test="snapshot-policy = 'cut-off'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            CUT_OFF
                                        </option>
                                    </select>

                                    <label for="list-deltas-policy">List deltas policy:</label>
                                    <select class="form-control" type="text" name="list-deltas-policy">
                                        <option>
                                            <xsl:if test="list-deltas-policy='rw-m'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            RW_M
                                        </option>
                                        <option>
                                            <xsl:if test="list-deltas-policy='r-m'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            R_M
                                        </option>
                                        <option>
                                            <xsl:if test="list-deltas-policy = 'r-ms'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            R_MS
                                        </option>
                                        <option>
                                            <xsl:if test="list-deltas-policy = 'r-sm'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            R_SM
                                        </option>
                                        <option>
                                            <xsl:if test="list-deltas-policy = 'r-any'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            R_ANY
                                        </option>
                                        <option>
                                            <xsl:if test="list-deltas-policy = 'r-s'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            R_S
                                        </option>
                                        <option>
                                            <xsl:if test="list-deltas-policy = 'cut-off'">
                                                <xsl:attribute name="selected">selected</xsl:attribute>
                                            </xsl:if>
                                            CUT_OFF
                                        </option>
                                    </select>

                                    <label for="database-size-limit">Database size limit:</label>
                                    <input class="form-control" name="database-size-limit" value="{database-size-limit}" type="text" placeholder="1m"/>

                                    <label for="database-records-count-limit">Database records count limit:</label>
                                    <input class="form-control" name="database-records-count-limit" value="{database-records-count-limit}" type="text" placeholder="1024"/>

                                    <label for="database-lb-log-type-name">LB push log type name:</label>
                                    <input class="form-control" name="lb-push-log-type-name" value="{lb-push-log-type-name}" type="text" placeholder="search_app_configs"/>

                                    <input type="submit" class="btn btn-default btn-sm" value="Update"/>
                                    <xsl:text>&#160;</xsl:text>
                                    <input type="button" class="cancel-button btn btn-sm" value="Cancel"/>
                                </form>
                            </td>
                        </tr>

                    </xsl:for-each>

                </table>
                <hr/>

                <form method="POST" action="/z/app-settings/replace">
                    <div class="form-group">
                        <label for="app-name">App Name:</label>
                        <input class="form-control" name="app-name" id="app-name" type="text" placeholder="global"/>
                        <label for="database-id">Database Id:</label>
                        <input class="form-control" name="database-id" id="database-id" type="text" placeholder="*"/>

                        <xsl:copy-of select="ya:checkbox('use-cache', 'Кэшировать', false())"/>
                        <xsl:copy-of select="ya:checkbox('no-keep-deltas', 'Не хранить дельты', false())"/>
                        <xsl:copy-of select="ya:checkbox('have-dump-in-yt', 'Дампить в YT', have-dump-in-yt = 'true')"/>

                        <label for="snapshot-policy">Snapshot policy:</label>
                        <select class="form-control" name="snapshot-policy">
                            <option>RW_M</option>
                            <option>R_M</option>
                            <option>R_MS</option>
                            <option>R_SM</option>
                            <option>R_ANY</option>
                            <option>R_S</option>
                            <option>CUT_OFF</option>
                        </select>

                        <label for="list-deltas-policy">List deltas policy:</label>
                        <select class="form-control" type="text" name="list-deltas-policy">
                            <option>RW_M</option>
                            <option>R_M</option>
                            <option>R_MS</option>
                            <option>R_SM</option>
                            <option>R_ANY</option>
                            <option>R_S</option>
                            <option>CUT_OFF</option>
                        </select>

                        <label for="database-size-limit">Database size limit:</label>
                        <input class="form-control" name="database-size-limit" id="database-size-limit" type="text" placeholder="1m"/>

                        <label for="database-records-count-limit">Database records count limit:</label>
                        <input class="form-control" name="database-records-count-limit" id="database-records-count-limit" type="text" placeholder="1024"/>

                        <label for="database-lb-log-type-name">LB push log type name:</label>
                        <input class="form-control" name="lb-push-log-type-name" value="{lb-push-log-type-name}" type="text" placeholder="search_app_configs"/>
                    </div>
                    <input type="submit" class="btn btn-default" value="Replace"/>
                </form>

            </div>
        </div>

    </xsl:template>

    <xsl:function name="ya:checkbox">
        <xsl:param name="name"/>
        <xsl:param name="title"/>
        <xsl:param name="checked"/>

        <div class="checkbox">
            <label>
                <input type="checkbox" name="{$name}" value="true">
                    <xsl:if test="$checked">
                        <xsl:attribute name="checked"/>
                    </xsl:if>
                    <xsl:value-of select="$title"/>
                </input>
            </label>
        </div>
    </xsl:function>


</xsl:stylesheet>

