package ru.yandex.chemodan.app.dataapi.web.admin;

import javax.annotation.PostConstruct;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.NS;
import ru.yandex.chemodan.app.dataapi.core.dao.support.DataApiRandomValueGenerator;
import ru.yandex.commune.a3.ActionApp;
import ru.yandex.commune.a3.admin.ActionListPageConfigurator;
import ru.yandex.commune.a3.admin.ActionListPageParams;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.misc.io.http.UriBuilder;
import ru.yandex.misc.ip.IpPort;
import ru.yandex.misc.net.HostnameUtils;

/**
 * @author tolmalev
 */
@Configuration
public class DataApiActionsAdminContextConfiguration {

    @Autowired
    private AdminApp adminApp;

    @Autowired
    private ActionApp actionApp;
    @Value("${dataapi.external.url}")
    private String url;
    @Value("${a3.port}")
    private IpPort a3Port;

    @PostConstruct
    public void init() {
        if (url.isEmpty()) {
            url = HostnameUtils.localHostname();
        }

        ListF<ActionListPageParams> params = Cf.list(
                params("/a3", "",
                        "Эти ручки не рекомендуется использовать вообще. Они представлены скорее для справки."),
                params("/api", ru.yandex.chemodan.util.web.NS.API, "Основные ручки API."),
                params("/profile", NS.PROFILE, "Ручки персонализации."),
                params("/internal", NS.INTERNAL, "Ручки для внутреннего использования."),
                params("/", NS.ROOT, "Все прочие ручки."));

        ActionListPageConfigurator.configure(adminApp, actionApp, params);
    }

    private ActionListPageParams params(String path, String namespace, String header) {
        return ActionListPageParams
                .cons(UriBuilder.cons("http://" + url).setPort(a3Port.getPort()).appendPath(path).toUrl())
                .withNamespace(namespace)
                .withRepositoryRoot(
                        "https://github.yandex-team.ru/media/disk-apps/blob/master/common/src/main/java/")
                .withHeader(header)
                .withDisclaimer(header)
                .withRandomValueGenerator(new DataApiRandomValueGenerator());
    }
}
