package ru.yandex.chemodan.app.dataapi.web.admin;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.MetaUser;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.misc.lang.Validate;

/**
 * @author tolmalev
 */
public class DataApiAdminPageBase {

    protected final UserMetaManager userManager;

    public DataApiAdminPageBase(UserMetaManager userManager) {
        this.userManager = userManager;
    }

    public MetaUser getUser(String stringId) {
        Validate.notEmpty(stringId, "stringId");
        return userManager.findMetaUser(DataApiUserId.parse(stringId)).get();
    }
}
