package ru.yandex.chemodan.app.dataapi.web.admin;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFieldMarshallerUnmarshaller;
import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabasesRegistry;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChangeMarshallerUnmarshaller;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChangeMarshallerUnmarshaller;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManager;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.limiter.access.AccessRateLimitsRegistry;
import ru.yandex.chemodan.app.dataapi.core.manager.DataApiManager;
import ru.yandex.chemodan.boot.admin.AdminBenderConfigurator;
import ru.yandex.commune.admin.web.AdminApp;
import ru.yandex.commune.zk2.admin.ZkAdminContextConfiguration;

/**
 * @author tolmalev
 */
@Configuration
@Import(ZkAdminContextConfiguration.class)
public class DataApiCoreAdminContextConfiguration {

    @Bean
    public UserDatabasesAdminPage userDatabasesAdminPage(UserMetaManager userMetaManager,
            DiskDataSource dataApiManager, AdminApp adminApp)
    {
        UserDatabasesAdminPage page = new UserDatabasesAdminPage(userMetaManager, dataApiManager);
        adminApp.registerAdminPage(Option.of("Data"), page);
        return page;
    }

    @Bean
    public DatabaseInfoAdminPage databaseInfoAdminPage(UserMetaManager userMetaManager,
            DataApiManager dataApiManager, AdminApp adminApp)
    {
        DatabaseInfoAdminPage page = new DatabaseInfoAdminPage(userMetaManager, dataApiManager);
        adminApp.registerHiddenAdminPage(page);
        return page;
    }

    @Bean
    public ExternalDatabasesAdminPage externalDatabasesAdminPage(
            ExternalDatabasesRegistry externalDatabasesRegistry, AdminApp adminApp)
    {
        ExternalDatabasesAdminPage page = new ExternalDatabasesAdminPage(externalDatabasesRegistry);
        adminApp.registerAdminPage(Option.of("Data"), page);
        return page;
    }

    @Profile("dataapi")
    @Bean
    public TypeSettingsAdminPage typeSettingsAdminPage(TypeSettingsRegistry typeSettingsRegistry, AdminApp adminApp) {
        TypeSettingsAdminPage page = new TypeSettingsAdminPage(typeSettingsRegistry);
        adminApp.registerAdminPage(Option.of("Data"), page);
        return page;
    }

    @Bean
    public AppSettingsAdminPage appSettingsAdminPage(AppSettingsRegistry registry, AdminApp adminApp)  {
        AppSettingsAdminPage page = new AppSettingsAdminPage(registry);
        adminApp.registerAdminPage(Option.of("Data"), page);
        return page;
    }

    @Bean
    public AccessRateLimitsAdminPage accessRateLimitsAdminPage(AccessRateLimitsRegistry registry, AdminApp adminApp) {
        AccessRateLimitsAdminPage page = new AccessRateLimitsAdminPage(registry);
        adminApp.registerAdminPage(Option.of("Data"), page);
        return page;
    }

    @Bean
    public AdminBenderConfigurator adminBenderConfigurator() {
        return baseBuilder -> baseBuilder
                .add(DataField.class,
                        new DataFieldMarshallerUnmarshaller(),
                        new DataFieldMarshallerUnmarshaller())
                .add(RecordChange.class,
                        new RecordChangeMarshallerUnmarshaller(),
                        new RecordChangeMarshallerUnmarshaller())
                .add(FieldChange.class,
                        new FieldChangeMarshallerUnmarshaller(),
                        new FieldChangeMarshallerUnmarshaller());
    }
}
