<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        exclude-result-prefixes="xsl z"
        xmlns:z="urn:zscript-functions"
        version="2.0">

    <xsl:import href="admin://common.xsl"/>

    <xsl:template match="page" mode="head-extra">
        <link rel="stylesheet" href="/z/r/sql/style.css"/>
    </xsl:template>

    <xsl:template match="page" mode="content">
        <xsl:apply-templates select="content"/>
    </xsl:template>

    <xsl:template match="content">
        <ul class="nav nav-tabs">
            <xsl:variable name="is-execute" select="z:iif-url-starts-with('/z/dataapi-sql/execute', true(), false()) = true()"/>
            <li class="{z:iif2($is-execute, '', 'active')}">
                <a href="/z/dataapi-sql">Find All</a>
            </li>
            <li class="{z:iif2($is-execute, 'active', '')}">
                <a href="/z/dataapi-sql/execute">Execute</a>
            </li>
        </ul>
        <div class="form">
            <form method="POST">
                <textarea name="query" class="submit" autofocus="1" style="height: 4em;">
                    <xsl:value-of select="/page/req/query/param[@name='query']"/>
                </textarea>
                <div class="form-inline form-actions">
                    Uid: <xsl:text> </xsl:text>
                    <input class="span3" id="ds" name="userId" value="{uid}"/>
                    <xsl:text> </xsl:text>
                    <button type="submit" class="btn btn-primary">Run</button>
                </div>
            </form>
            <xsl:if test="query">
                <xsl:choose>
                    <xsl:when test="error">
                        <div id="error" class="alert alert-error" style="display: block; ">
                            <strong>Problem! </strong>
                            <span class="message"><xsl:value-of select="error"/></span>
                        </div>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates select="rows"/>
                        <xsl:apply-templates select="rows-affected"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </div>
    </xsl:template>

    <xsl:template match="rows-affected">
        <div class="alert alert-success">
            Query <strong>OK</strong>, <xsl:value-of select="."/> rows affected.
        </div>
    </xsl:template>

    <xsl:template match="rows">
        <div class="alert alert-success">
            Query <strong>OK</strong>, returned <xsl:value-of select="count(row)"/> rows.
        </div>
        <table class="table table-condensed" id="results-table">
            <thead>
                <xsl:for-each select="row[1]">
                    <tr class="headers">
                        <xsl:for-each select="items">
                            <th>
                                <xsl:value-of select="column"/>
                            </th>
                        </xsl:for-each>
                    </tr>
                </xsl:for-each>
            </thead>
            <tbody class="results">
                <xsl:for-each select="row">
                    <tr>
                        <xsl:for-each select="items">
                            <td>
                                <xsl:value-of select="value"/>
                            </td>
                        </xsl:for-each>
                    </tr>
                </xsl:for-each>
            </tbody>
        </table>
    </xsl:template>

</xsl:stylesheet>
