$(document).ready(function() {
    $(".delete-record").click(function() {
        var tr = $(this).closest('tr');

        var uid = tr.data("uid")
        var databaseId = tr.data("database-id")
        var app = tr.data("app")
        var collectionId = tr.data("collection-id")
        var recordId = tr.data("record-id")

        var $confirm = $("#confirm");
        var body = $(".modal-body", $confirm);
        body.html('<h4>Remove record ' + collectionId + ':' + recordId + '?</h4>')

        var footer = $(".modal-footer", $confirm);
        footer.html('')

        var removeLink = $('<a class="btn btn-danger">Yes</a>')

        footer.html('')
        footer.append(removeLink)
        footer.append($('<a class="btn btn-primary" data-dismiss="modal">No</a>'))

        removeLink.click(function() {
            $.post(
                    "database-info/remove-record.json",
                    {
                        uid: uid,
                        databaseId: databaseId,
                        app: app,
                        collectionId: collectionId,
                        recordId: recordId
                    },
                    function(data) {
                        if (data.message) {
                            showAjaxErrorPopup(data)
                        } else {
                            $("#confirm").modal('hide');
                            tr.remove();
                        }
                    },
                    "json"
            )
        })

        $confirm.modal();
    })

    $(".delete-field").click(function() {
        var $this = $(this);
        var tr = $this.closest('tr');

        var uid = tr.data("uid")
        var databaseId = tr.data("database-id")
        var app = tr.data("app")
        var collectionId = tr.data("collection-id")
        var recordId = tr.data("record-id")

        var fieldId = $this.data("field-id")

        var $confirm = $("#confirm");
        var body = $(".modal-body", $confirm);
        body.html('<h4>Remove field ' + collectionId + ':' + recordId + ':' + fieldId + '?</h4>')

        var footer = $(".modal-footer", $confirm);
        footer.html('')

        var removeLink = $('<a class="btn btn-danger">Yes</a>')

        footer.html('')
        footer.append(removeLink)
        footer.append($('<a class="btn btn-primary" data-dismiss="modal">No</a>'))

        removeLink.click(function() {
            $.post(
                    "database-info/remove-record-field.json",
                    {
                        uid: uid,
                        databaseId: databaseId,
                        app: app,
                        collectionId: collectionId,
                        recordId: recordId,
                        fieldId: fieldId
                    },
                    function(data) {
                        if (data.message) {
                            showAjaxErrorPopup(data)
                        } else {
                            $("#confirm").modal('hide');
                            $this.closest("div").remove();
                        }
                    },
                    "json"
            )
        })

        $confirm.modal();
    })


    $(".add-to-collection").click(function() {
        var $this = $(this);

        var uid = $this.data("uid")
        var databaseId = $this.data("database-id")
        var app = $this.data("app")
        var collectionId = $this.data("collection-id")

        var $dialog = $("#add-to-collection");

        $(".btn-primary", $dialog).click(function() {
            var recordId = $dialog.find("[name=recordId]").val()
            $.post(
                    "database-info/create-record.json",
                    {
                        uid: uid,
                        databaseId: databaseId,
                        app: app,
                        collectionId: collectionId,
                        recordId: recordId
                    },
                    function(data) {
                        if (data.message) {
                            showAjaxErrorPopup(data)
                        } else {
                            window.location.reload()
                        }
                    },
                    "json"
            )
        })
        $dialog.modal();
    })

    $("#add-record-btn").click(function() {
        var $this = $(this);

        var uid = $this.data("uid")
        var databaseId = $this.data("database-id")
        var app = $this.data("app")

        var $dialog = $("#add-to-database");

        $(".btn-primary", $dialog).click(function() {
            var recordId = $dialog.find("[name=recordId]").val()
            var collectionId = $dialog.find("[name=collectionId]").val()
            $.post(
                    "database-info/create-record.json",
                    {
                        uid: uid,
                        databaseId: databaseId,
                        app: app,
                        collectionId: collectionId,
                        recordId: recordId
                    },
                    function(data) {
                        if (data.message) {
                            showAjaxErrorPopup(data)
                        } else {
                            window.location.reload()
                        }
                    },
                    "json"
            )
        })
        $dialog.modal();
    })

    $("#apply-delta-btn").click(function() {
        var $this = $(this);

        var uid = $this.data("uid")
        var databaseId = $this.data("database-id")
        var app = $this.data("app")

        var $dialog = $("#apply-delta");

        $(".btn-primary", $dialog).click(function() {
            var changes = $dialog.find("[name=changes]").val()
            $.post(
                    "database-info/delta.json",
                    {   uid: uid,
                        databaseId: databaseId,
                        app: app,
                        delta: changes
                    },
                    function(data) {
                        if (data.message) {
                            showAjaxErrorPopup(data)
                        } else {
                            window.location.reload()
                        }
                    },
                    "json"
            )
        })
        $dialog.modal();
    })

    $(".add-record-field").click(function() {
        var $this = $(this);
        var tr = $this.closest('tr');

        var uid = tr.data("uid")
        var databaseId = tr.data("database-id")
        var app = tr.data("app")
        var collectionId = tr.data("collection-id")
        var recordId = tr.data("record-id")

        var $dialog = $("#add-record-field");

        $(".btn-primary", $dialog).click(function() {
            var fieldId = $dialog.find("[name=fieldId]").val()
            var type = $dialog.find("[name=type]").val()
            var value = $dialog.find("[name=value]").val()

            $.post(
                    "database-info/put-record-field.json",
                    {
                        uid: uid,
                        databaseId: databaseId,
                        app: app,
                        collectionId: collectionId,
                        recordId: recordId,
                        fieldId: fieldId,
                        type: type,
                        value: value
                    },
                    function(data) {
                        if (data.message) {
                            showAjaxErrorPopup(data)
                        } else {
                            window.location.reload()
                        }
                    },
                    "json"
            )
        })
        $dialog.modal();
    });

    $("#choose-field-type").val("string");

    $("#choose-field-type").change(function () {
        var type = $("#choose-field-type option:selected").text();
        var container = $("#field-value");
        if (type == 'list' && container.has("input").length) {
            container.remove("input");
            container.html("<textarea name='value' rows='5'/>");
        } else if (type != 'list' && container.has("textarea").length) {
            container.remove("textarea");
            container.html("<input name='value'/>");
        }
    });

    $(".show-long-value").click(function() {
        var $shortField = $(this).parent();
        var $longField = $shortField.siblings(".long-field-full");

        $shortField.hide();
        $longField.show();
    });
});
